# e-File SMK Negeri 1 Salam

Sistem manajemen dokumen internal dengan peran `root`, `administrator`, `verifikator`, dan `pendidik`. Mendukung Data Statis & Dinamis, upload, verifikasi, pencarian, dan pagination.

## Struktur Proyek

```
assets/
  css/style.css
  img/logo.png
  js/script.js
config/
  config.php
  database.php
includes/
  header.php
  footer.php
pages/
  data_dinamis.php
  data_statis.php
  documents.php
  users.php
  upload.php
  verification.php
  folders.php
login.php, dashboard.php, logout.php, index.php
```

## Basis Data

- File skema: `database.sql`
- Hash password: menggunakan `password_hash()` (bcrypt) di PHP.
 
### Akun Seed & Password Default

- `root` → `!B0r0b4d4r`
- `admin` → `!B0r0b4d4r`
- `verifikator1` → `!Dapodik2022#`
- `pendidik1` → `!Dapodik2022#`

Semua password disimpan sebagai hash bcrypt dan diverifikasi menggunakan `password_verify()` di `login.php`.

### Impor Skema/Seed

- Gunakan `database.sql` di root proyek (tidak mengandung `CREATE DATABASE`/`USE`).
- Jika memakai `efile/database.sql`, hapus baris `CREATE DATABASE` dan `USE` apabila user MySQL tidak memiliki hak `CREATE DATABASE`.
- Impor via phpMyAdmin: pilih database yang sesuai (`DB_NAME` di `config/database.php`) → Import → pilih file `.sql` → jalankan.

### Sinkronisasi Password pada DB yang Sudah Ada

Jalankan SQL berikut untuk memperbarui password default jika akun sudah ada:

```sql
UPDATE users SET password='$2y$10$CKtmSU5nxiefclgXJo7hhe.C3UZmP40JisOSi8KuCGHPMY.OJ6DTy' WHERE username='root';
UPDATE users SET password='$2y$10$CKtmSU5nxiefclgXJo7hhe.C3UZmP40JisOSi8KuCGHPMY.OJ6DTy' WHERE username='admin';
UPDATE users SET password='$2y$10$6c/pk/rqAwew0GkKa7LVQua5uj5GI84D8zUqnOcQgh8MUJfyo0UZ2' WHERE username='verifikator1';
UPDATE users SET password='$2y$10$6c/pk/rqAwew0GkKa7LVQua5uj5GI84D8zUqnOcQgh8MUJfyo0UZ2' WHERE username='pendidik1';
```

Rekomendasi: setelah deploy, ubah password default melalui menu Profil → Ubah Password.

## Konfigurasi Server

- Apache/Laragon: gunakan `.htaccess` untuk menyembunyikan `.php` dan header keamanan.
- Nginx: set `try_files $uri $uri/ $uri.php;` pada server block.
- Pastikan `BASE_URL` di `config/config.php` diubah ke domain/IP publik.

## Keamanan (Public IP)

- Sesi: `HttpOnly`, `Secure` (aktif otomatis saat HTTPS), `SameSite=Lax`. ID sesi diregenerasi saat login.
- SQL: semua query mutlak menggunakan prepared statements.
- Upload: file disimpan dengan nama terstandar, menghindari overwrite; batasi tipe ke PDF/DOC/XLS/JPEG/PNG; periksa ukuran `MAX_FILE_SIZE`.
- CSRF: seluruh formulir sensitif kini memakai token dan validasi (login, verifikasi dokumen, upload, impor pengguna, edit pengguna, buat folder, toggle/delete pengguna).
- Header: `.htaccess` memasang `X-Content-Type-Options`, `X-Frame-Options`, `Referrer-Policy`, `CSP` dasar, dan mematikan directory listing.
- Error: nonaktifkan error display di produksi; gunakan log.

## Fitur Utama

- Data Statis & Dinamis: pagination 12 folder per halaman, pencarian nama folder.
- Dokumen: back button kontekstual, menampilkan waktu upload & verifikasi, filter sesuai peran.
- Pengguna: pencarian nama/username, pagination 20 per halaman, kolom "Terakhir Login".

## Operasional

- Jalankan di PHP 8+ dan MySQL/MariaDB.
- Pastikan `uploads/` dapat ditulis oleh server.
- Ganti `BASE_URL` saat deploy.

## Development

- Standard UI: ukuran header `h2` dan ikon 20px.
- Login: logo proporsional, judul "Manajeman e-File".

## Melanjutkan Kolaborasi

Tuliskan perubahan yang diinginkan secara jelas (fitur, halaman, flow). Saya akan:

- Membuat daftar tugas dan menyelesaikannya bertahap.
- Menyediakan patch spesifik file, SQL, dan konfigurasi.
- Memberi saran keamanan dan pengujian sebelum rilis.