// Script untuk aplikasi E-File

// Konfirmasi hapus
function confirmDelete(event, message) {
    if (!confirm(message || 'Apakah Anda yakin ingin menghapus item ini?')) {
        event.preventDefault();
        return false;
    }
    return true;
}

// Preview file sebelum upload
function previewFile(input, previewElement) {
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        
        reader.onload = function(e) {
            const extension = input.files[0].name.split('.').pop().toLowerCase();
            
            if (['jpg', 'jpeg', 'png'].includes(extension)) {
                // Preview gambar
                $(previewElement).html(`<img src="${e.target.result}" class="img-fluid" />`);
            } else if (['pdf'].includes(extension)) {
                // Icon untuk PDF
                $(previewElement).html(`<div class="text-center"><i class="fas fa-file-pdf fa-5x text-danger"></i><p class="mt-2">${input.files[0].name}</p></div>`);
            } else if (['doc', 'docx'].includes(extension)) {
                // Icon untuk Word
                $(previewElement).html(`<div class="text-center"><i class="fas fa-file-word fa-5x text-primary"></i><p class="mt-2">${input.files[0].name}</p></div>`);
            } else if (['xls', 'xlsx'].includes(extension)) {
                // Icon untuk Excel
                $(previewElement).html(`<div class="text-center"><i class="fas fa-file-excel fa-5x text-success"></i><p class="mt-2">${input.files[0].name}</p></div>`);
            } else {
                // Icon untuk file lainnya
                $(previewElement).html(`<div class="text-center"><i class="fas fa-file fa-5x text-secondary"></i><p class="mt-2">${input.files[0].name}</p></div>`);
            }
        }
        
        reader.readAsDataURL(input.files[0]);
    }
}

// Inisialisasi komponen saat dokumen siap
$(document).ready(function() {
    // Aktifkan tooltips
    $('[data-bs-toggle="tooltip"]').tooltip();
    
    // Aktifkan dropdowns
    $('.dropdown-toggle').dropdown();
    
    // Aktifkan file preview
    $('.custom-file-input').on('change', function() {
        const fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').html(fileName);
        
        if ($(this).data('preview')) {
            previewFile(this, $(this).data('preview'));
        }
    });
    
    // Konfirmasi hapus (Bootstrap Modal) untuk semua tombol dengan class .btn-delete
    $(document).on('click', '.btn-delete', function(e) {
        e.preventDefault();
        const href = $(this).attr('href');
        const message = $(this).data('confirm-message') || 'Apakah Anda yakin ingin menghapus item ini? Tindakan ini tidak dapat dibatalkan.';
        const modalEl = document.getElementById('confirmDeleteModal');
        if (!modalEl) {
            // Fallback jika modal tidak tersedia
            return confirmDelete(e, message);
        }
        // Set pesan
        const msgEl = document.getElementById('confirmDeleteMessage');
        if (msgEl) { msgEl.textContent = message; }
        // Pasang handler tombol Hapus
        const proceedBtn = document.getElementById('confirmDeleteProceed');
        if (proceedBtn) {
            proceedBtn.onclick = function() {
                window.location.href = href;
            };
        }
        const modal = new bootstrap.Modal(modalEl, { focus: true });
        modal.show();
        return false;
    });

    // Konfirmasi tindakan umum (mis. aktif/nonaktif) untuk tombol dengan class .btn-toggle
    $(document).on('click', '.btn-toggle', function(e) {
        e.preventDefault();
        if ($(this).hasClass('disabled')) { return false; }
        const href = $(this).attr('href');
        const message = $(this).data('confirm-message') || 'Apakah Anda yakin ingin melanjutkan tindakan ini?';
        const modalEl = document.getElementById('confirmActionModal');
        if (!modalEl) {
            // Fallback ke confirm standar
            return confirmDelete(e, message);
        }
        const msgEl = document.getElementById('confirmActionMessage');
        if (msgEl) { msgEl.textContent = message; }
        const proceedBtn = document.getElementById('confirmActionProceed');
        if (proceedBtn) {
            proceedBtn.onclick = function() {
                window.location.href = href;
            };
        }
        const modal = new bootstrap.Modal(modalEl, { focus: true });
        modal.show();
        return false;
    });
    
    // Auto-dismiss alerts setelah 5 detik
    setTimeout(function() {
        $('.alert-dismissible').alert('close');
    }, 5000);
    
    // Preview PDF di modal ketika link dengan class .preview-pdf diklik
    $('a.preview-pdf').on('click', function(e) {
        e.preventDefault();
        var url = $(this).attr('href');
        var modalEl = document.getElementById('pdfPreviewModal');
        // Simpan URL sementara dan set src saat modal benar-benar tampil
        modalEl.dataset.previewUrl = url;
        // Nonaktifkan auto-focus Bootstrap untuk menghindari fokus sebelum aria-hidden dihapus
        var modal = new bootstrap.Modal(modalEl, { focus: false });
        modal.show();
    });
});
// Sidebar toggle
document.addEventListener('DOMContentLoaded', function() {
  var toggle = document.getElementById('sidebarToggle');
  var sidebar = document.getElementById('sidebar');
  if (toggle && sidebar) {
    toggle.addEventListener('click', function() {
      sidebar.classList.toggle('collapsed');
      document.body.classList.toggle('sidebar-collapsed');
    });
  }
});
// Sinkronisasi atribut aria saat modal tampil/ditutup untuk menghindari konflik fokus
document.addEventListener('DOMContentLoaded', function() {
  var modalEl = document.getElementById('pdfPreviewModal');
  if (modalEl) {
    // Utility: set inert pada konten latar (selain modal dan backdrop)
    function setBackgroundInert(enable) {
      var children = Array.prototype.slice.call(document.body.children);
      children.forEach(function(el) {
        if (el === modalEl) return;
        if (el.classList && el.classList.contains('modal-backdrop')) return;
        if (enable) {
          el.setAttribute('inert', '');
          el.setAttribute('aria-hidden', 'true');
        } else {
          el.removeAttribute('inert');
          el.removeAttribute('aria-hidden');
        }
      });
    }
    // Pada fase show, nonaktifkan latar dengan inert agar fokus aman
    modalEl.addEventListener('show.bs.modal', function() {
      setBackgroundInert(true);
    });
    modalEl.addEventListener('shown.bs.modal', function() {
      // Set iframe src setelah modal siap, menghindari race pada channel pesan
      var frame = document.getElementById('pdfPreviewFrame');
      if (frame && modalEl.dataset.previewUrl) {
        frame.src = modalEl.dataset.previewUrl;
        delete modalEl.dataset.previewUrl;
      }
      // Fokus manual dihilangkan untuk mencegah konflik ARIA saat transisi
    });
    modalEl.addEventListener('hidden.bs.modal', function() {
      // Pulihkan latar
      setBackgroundInert(false);
      // Reset iframe src untuk menutup channel dan mencegah error listener async
      var frame = document.getElementById('pdfPreviewFrame');
      if (frame) {
        frame.src = '';
      }
    });
  }
});

// Tangani unhandled Promise rejection khusus dari channel pesan ekstensi/iframe agar tidak mengganggu
window.addEventListener('unhandledrejection', function(event) {
  var reason = event && event.reason ? String(event.reason) : '';
  if (reason && reason.indexOf('message channel closed') !== -1) {
    // Cegah log error di konsol untuk kasus ini karena tidak berdampak ke fungsionalitas aplikasi
    event.preventDefault();
  }
});