<?php
require_once 'config/config.php';
require_once 'config/database.php';

// Cek login
if (!isLoggedIn()) {
redirect('/login');
}

// Ambil data statistik sesuai role
$user_id = $_SESSION['user_id'];
$role = $_SESSION['user_role'];
// Fallback: jika role kosong tapi username adalah 'root', perlakukan sebagai root
if (empty($role) && (isset($_SESSION['user_username']) && $_SESSION['user_username'] === 'root')) {
    $role = 'root';
}

// Statistik umum
$totalDokumen = 0;
$dokumenMenunggu = 0;
$dokumenDiverifikasi = 0;
$dokumenDraft = 0;
$totalPendidik = 0;
$totalVerifikator = 0;
// Statistik pengguna
$userAktif = 0;
$userNonaktif = 0;

// Query sesuai role
if ($role == 'administrator' || $role == 'root') {
    // Admin melihat semua dokumen
    $stmt = $conn->query("SELECT COUNT(*) as total FROM dokumen");
    $totalDokumen = $stmt->fetch_assoc()['total'];
    
    $stmt = $conn->query("SELECT COUNT(*) as total FROM dokumen WHERE status = 'menunggu_verifikasi'");
    $dokumenMenunggu = $stmt->fetch_assoc()['total'];
    
    $stmt = $conn->query("SELECT COUNT(*) as total FROM dokumen WHERE status = 'diverifikasi'");
    $dokumenDiverifikasi = $stmt->fetch_assoc()['total'];
    
    $stmt = $conn->query("SELECT COUNT(*) as total FROM dokumen WHERE status = 'draft'");
    $dokumenDraft = $stmt->fetch_assoc()['total'];
    
    // Dokumen terbaru + status verifikasi terbaru
    $stmt = $conn->query("SELECT d.*, u.nama_lengkap, k.nama_kategori,
                         v.status AS ver_status, uv.nama_lengkap AS verifikator_nama, v.tanggal_verifikasi
                         FROM dokumen d 
                         LEFT JOIN users u ON d.user_id = u.id 
                         LEFT JOIN kategori_dokumen k ON d.kategori_id = k.id 
                         LEFT JOIN verifikasi v ON v.dokumen_id = d.id AND v.id = (
                             SELECT MAX(vv.id) FROM verifikasi vv WHERE vv.dokumen_id = d.id
                         )
                         LEFT JOIN users uv ON uv.id = v.verifikator_id
                         ORDER BY d.created_at DESC LIMIT 5");
    $dokumenTerbaru = $stmt->fetch_all(MYSQLI_ASSOC);

    // Hitung total pendidik (semua akun berperan 'pendidik')
    $stmt = $conn->query("SELECT COUNT(*) as total FROM users WHERE role = 'pendidik'");
    $totalPendidik = $stmt->fetch_assoc()['total'];

    // Hitung total verifikator
    $stmt = $conn->query("SELECT COUNT(*) as total FROM users WHERE role = 'verifikator'");
    $totalVerifikator = $stmt->fetch_assoc()['total'];

    // Total User Aktif & Tidak Aktif
    $stmt = $conn->query("SELECT COUNT(*) as total FROM users WHERE status = 1");
    $userAktif = $stmt->fetch_assoc()['total'];
    $stmt = $conn->query("SELECT COUNT(*) as total FROM users WHERE status = 0");
    $userNonaktif = $stmt->fetch_assoc()['total'];
    
} elseif ($role == 'verifikator') {
    // Verifikator melihat dokumen yang perlu diverifikasi
    $stmt = $conn->query("SELECT COUNT(*) as total FROM dokumen d LEFT JOIN users u ON d.user_id = u.id WHERE d.status = 'menunggu_verifikasi' AND u.role = 'pendidik'");
    $dokumenMenunggu = $stmt->fetch_assoc()['total'];
    
    $stmt = $conn->prepare("SELECT COUNT(*) as total FROM verifikasi WHERE verifikator_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $totalVerifikasi = $result->fetch_assoc()['total'];

    // Hitung draft (hanya milik pendidik)
    $stmt = $conn->query("SELECT COUNT(*) as total FROM dokumen d LEFT JOIN users u ON d.user_id = u.id WHERE d.status = 'draft' AND u.role = 'pendidik'");
    $dokumenDraft = $stmt->fetch_assoc()['total'];
    
    // Dokumen yang menunggu verifikasi
    $stmt = $conn->query("SELECT d.*, u.nama_lengkap, k.nama_kategori 
                         FROM dokumen d 
                         LEFT JOIN users u ON d.user_id = u.id 
                         LEFT JOIN kategori_dokumen k ON d.kategori_id = k.id 
                         WHERE d.status = 'menunggu_verifikasi' AND u.role = 'pendidik'
                         ORDER BY d.created_at DESC LIMIT 5");
    $dokumenMenungguList = $stmt->fetch_all(MYSQLI_ASSOC);

    // Hitung total pendidik untuk verifikator
    $stmt = $conn->query("SELECT COUNT(*) as total FROM users WHERE role = 'pendidik'");
    $totalPendidik = $stmt->fetch_assoc()['total'];

    // Hitung total verifikator (semua akun berperan 'verifikator')
    $stmt = $conn->query("SELECT COUNT(*) as total FROM users WHERE role = 'verifikator'");
    $totalVerifikator = $stmt->fetch_assoc()['total'];
    
} elseif ($role == 'pendidik') {
    // Pendidik melihat dokumen miliknya
    $stmt = $conn->prepare("SELECT COUNT(*) as total FROM dokumen WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $totalDokumen = $result->fetch_assoc()['total'];
    
    $stmt = $conn->prepare("SELECT COUNT(*) as total FROM dokumen WHERE user_id = ? AND status = 'menunggu_verifikasi'");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $dokumenMenunggu = $result->fetch_assoc()['total'];
    
    $stmt = $conn->prepare("SELECT COUNT(*) as total FROM dokumen WHERE user_id = ? AND status = 'diverifikasi'");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $dokumenDiverifikasi = $result->fetch_assoc()['total'];
    
    $stmt = $conn->prepare("SELECT COUNT(*) as total FROM dokumen WHERE user_id = ? AND status = 'draft'");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $dokumenDraft = $result->fetch_assoc()['total'];
    
    // Dokumen menunggu verifikasi milik pendidik (tampilkan 10 baris)
    $stmt = $conn->prepare("SELECT d.*, k.nama_kategori 
                           FROM dokumen d 
                           LEFT JOIN kategori_dokumen k ON d.kategori_id = k.id 
                           WHERE d.user_id = ? AND d.status = 'menunggu_verifikasi' 
                           ORDER BY d.created_at DESC LIMIT 10");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $dokumenSaya = $result->fetch_all(MYSQLI_ASSOC);

    // Untuk pendidik, total pendidik sesuai milik pendidik (1 akun)
    $totalPendidik = 1;
}

// Include header
include 'includes/header.php';
?>

<div class="row mb-4">
    <div class="col-md-12">
        <h2 class="mb-0"><i class="fas fa-tachometer-alt"></i> Dashboard</h2>
        <?php
            $roleDisplayParen = '';
            if ($role === 'root') {
                $roleDisplayParen = 'Administrator';
            } else {
                $roleDisplayParen = ucfirst($role);
            }
        ?>
        <p class="text-muted">Selamat datang, <?= htmlspecialchars($_SESSION['user_name']) ?> (<?= $roleDisplayParen ?>)</p>
    </div>
</div>

<!-- Statistik -->
<div class="row mb-4">
    <?php if ($role == 'administrator' || $role == 'root' || $role == 'pendidik'): ?>
    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted">Total Pendidik</h6>
                        <h3><?= $totalPendidik ?></h3>
                    </div>
                    <div class="icon">
                        <i class="fas fa-users"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if ($role == 'administrator' || $role == 'root'): ?>
    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted">Total Verifikator</h6>
                        <h3><?= $totalVerifikator ?></h3>
                    </div>
                    <div class="icon">
                        <i class="fas fa-user-tie"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <?php if ($role == 'administrator' || $role == 'root'): ?>
    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted">User Aktif</h6>
                        <h3><?= $userAktif ?></h3>
                    </div>
                    <div class="icon">
                        <i class="fas fa-user-check"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted">User Tidak Aktif</h6>
                        <h3><?= $userNonaktif ?></h3>
                    </div>
                    <div class="icon">
                        <i class="fas fa-user-times"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted">Total Dokumen</h6>
                        <h3><?= $totalDokumen ?></h3>
                    </div>
                    <div class="icon">
                        <i class="fas fa-file-alt"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted">Menunggu Verifikasi</h6>
                        <h3><?= $dokumenMenunggu ?></h3>
                    </div>
                    <div class="icon">
                        <i class="fas fa-clock"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php if ($role == 'administrator' || $role == 'root' || $role == 'pendidik'): ?>
    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted">Diverifikasi</h6>
                        <h3><?= $dokumenDiverifikasi ?></h3>
                    </div>
                    <div class="icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted">Draft</h6>
                        <h3><?= $dokumenDraft ?></h3>
                    </div>
                    <div class="icon">
                        <i class="fas fa-times-circle"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <?php if ($role == 'verifikator'): ?>
    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted">Total Pendidik</h6>
                        <h3><?= $totalPendidik ?></h3>
                    </div>
                    <div class="icon">
                        <i class="fas fa-users"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted">Total Verifikator</h6>
                        <h3><?= $totalVerifikator ?></h3>
                    </div>
                    <div class="icon">
                        <i class="fas fa-user-tie"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted">Total Diverifikasi</h6>
                        <h3><?= $totalVerifikasi ?? 0 ?></h3>
                    </div>
                    <div class="icon">
                        <i class="fas fa-check-double"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-sm-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="text-muted">Draft</h6>
                        <h3><?= $dokumenDraft ?></h3>
                    </div>
                    <div class="icon">
                        <i class="fas fa-times-circle"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- Konten Dashboard Berdasarkan Role -->
<?php if ($role == 'administrator' || $role == 'root'): ?>
    <!-- Dashboard Admin -->
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>Dokumen Terbaru</span>
<a href="<?= BASE_URL ?>/pages/documents" class="btn btn-sm btn-primary">Lihat Semua</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Judul</th>
                                    <th>Kategori</th>
                                    <th>Pengguna</th>
                                    <th>Status</th>
                                    <th>Verifikator</th>
                                    <th>Tanggal</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (isset($dokumenTerbaru) && count($dokumenTerbaru) > 0): ?>
                                    <?php $no = 1; foreach ($dokumenTerbaru as $dok): ?>
                                        <tr class="document-item">
                                            <td><?= $no++ ?></td>
                                            <td><?= $dok['judul'] ?></td>
                                            <td><?= $dok['nama_kategori'] ?? 'Tidak ada kategori' ?></td>
                                            <td><?= $dok['nama_lengkap'] ?></td>
                                            <td>
                                                <span class="badge bg-<?= 
                                                    $dok['status'] == 'draft' ? 'secondary' : 
                                                    ($dok['status'] == 'menunggu_verifikasi' ? 'warning' : 
                                                    ($dok['status'] == 'diverifikasi' ? 'success' : 'danger')) 
                                                ?>">
                                                    <?= ucfirst(str_replace('_', ' ', $dok['status'])) ?>
                                                </span>
                                            </td>
                                            <td>
                                                <?= !empty($dok['verifikator_nama']) ? htmlspecialchars($dok['verifikator_nama']) : '-' ?>
                                            </td>
                                            <td><?= date('d/m/Y', strtotime($dok['created_at'])) ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center">Tidak ada dokumen</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
    </div>
<?php elseif ($role == 'verifikator'): ?>
    <!-- Dashboard Verifikator -->
    <div class="row">
        <div class="col-md-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>Dokumen Menunggu Verifikasi</span>
<a href="<?= BASE_URL ?>/pages/verification" class="btn btn-sm btn-primary">Lihat Semua</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Judul</th>
                                    <th>Kategori</th>
                                    <th>Pengguna</th>
                                    <th>Tanggal</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (isset($dokumenMenungguList) && count($dokumenMenungguList) > 0): ?>
                                    <?php $no = 1; foreach ($dokumenMenungguList as $dok): ?>
                                        <tr class="document-item">
                                            <td><?= $no++ ?></td>
                                            <td><?= $dok['judul'] ?></td>
                                            <td><?= $dok['nama_kategori'] ?? 'Tidak ada kategori' ?></td>
                                            <td><?= $dok['nama_lengkap'] ?></td>
                                            <td><?= date('d/m/Y', strtotime($dok['created_at'])) ?></td>
                                            <td>
            <a href="<?= BASE_URL ?>/pages/verify_document?id=<?= $dok['id'] ?>" class="btn btn-sm btn-primary">
                <i class="fas fa-check-circle"></i> Verifikasi
            </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="5" class="text-center">Tidak ada dokumen yang menunggu verifikasi</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php elseif ($role == 'pendidik'): ?>
    <!-- Dashboard Pendidik -->
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>Dokumen Saya</span>
<a href="<?= BASE_URL ?>/pages/documents" class="btn btn-sm btn-primary">Lihat Semua</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <colgroup>
                                <col style="width:6%">
                                <col style="width:38%">
                                <col style="width:23%">
                                <col style="width:13%">
                                <col style="width:20%">
                            </colgroup>
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Judul</th>
                                    <th>Kategori</th>
                                    <th>Status</th>
                                    <th>Tanggal</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (isset($dokumenSaya) && count($dokumenSaya) > 0): ?>
                                    <?php $no = 1; foreach ($dokumenSaya as $dok): ?>
                                        <tr class="document-item">
                                            <td><?= $no++ ?></td>
                                            <td><?= $dok['judul'] ?></td>
                                            <td><?= $dok['nama_kategori'] ?? 'Tidak ada kategori' ?></td>
                                            <td>
                                                <span class="badge bg-<?= 
                                                    $dok['status'] == 'draft' ? 'secondary' : 
                                                    ($dok['status'] == 'menunggu_verifikasi' ? 'warning' : 
                                                    ($dok['status'] == 'diverifikasi' ? 'success' : 'danger')) 
                                                ?>">
                                                    <?= ucfirst(str_replace('_', ' ', $dok['status'])) ?>
                                                </span>
                                            </td>
                                            <td><?= date('d/m/Y', strtotime($dok['created_at'])) ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="5" class="text-center">Tidak ada dokumen yang menunggu verifikasi</td>
                                        </tr>
                                    <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
    </div>
<?php endif; ?>

<?php include 'includes/footer.php'; ?>