-- E-File Database Schema (MySQL)
-- Charset: utf8mb4, Collation: utf8mb4_general_ci

-- Buat database jika belum ada
CREATE DATABASE IF NOT EXISTS `efile_db`
  CHARACTER SET utf8mb4
  COLLATE utf8mb4_general_ci;
USE `efile_db`;

-- Hapus tabel jika ada (untuk pengulangan setup)
SET FOREIGN_KEY_CHECKS = 0;
DROP TABLE IF EXISTS `verifikasi`;
DROP TABLE IF EXISTS `dokumen`;
DROP TABLE IF EXISTS `folder`;
DROP TABLE IF EXISTS `kategori_dokumen`;
DROP TABLE IF EXISTS `log_aktivitas`;
DROP TABLE IF EXISTS `user_otp`;
DROP TABLE IF EXISTS `users`;
SET FOREIGN_KEY_CHECKS = 1;

-- Tabel users
CREATE TABLE `users` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `username` VARCHAR(64) NOT NULL,
  `password` VARCHAR(255) NOT NULL,
  `nama_lengkap` VARCHAR(150) NOT NULL,
  `email` VARCHAR(150) NULL,
  `role` ENUM('root','super_administrator','administrator','verifikator','pendidik') NOT NULL DEFAULT 'pendidik',
  `status` TINYINT(1) NOT NULL DEFAULT 1,
  `last_login` TIMESTAMP NULL DEFAULT NULL,
  `session_token` VARCHAR(64) NULL,
  `session_token_issued_at` TIMESTAMP NULL DEFAULT NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_users_username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Tabel kategori_dokumen
CREATE TABLE `kategori_dokumen` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `nama_kategori` VARCHAR(100) NOT NULL,
  `tipe` ENUM('dinamis','statis') NOT NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Tabel folder
CREATE TABLE `folder` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `kategori_id` INT UNSIGNED NOT NULL,
  `nama_folder` VARCHAR(100) NOT NULL,
  `created_by` INT UNSIGNED NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_folder_kategori` (`kategori_id`),
  KEY `idx_folder_created_by` (`created_by`),
  CONSTRAINT `fk_folder_kategori` FOREIGN KEY (`kategori_id`)
    REFERENCES `kategori_dokumen`(`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `fk_folder_created_by` FOREIGN KEY (`created_by`)
    REFERENCES `users`(`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Tabel dokumen
CREATE TABLE `dokumen` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `judul` VARCHAR(200) NOT NULL,
  `deskripsi` TEXT NULL,
  `file_path` VARCHAR(255) NOT NULL,
  `file_size` INT UNSIGNED NOT NULL,
  `file_type` VARCHAR(100) NOT NULL,
  `kategori_id` INT UNSIGNED NOT NULL,
  `folder_id` INT UNSIGNED NOT NULL,
  `user_id` INT UNSIGNED NULL,
  `status` ENUM('draft','menunggu_verifikasi','diverifikasi') NOT NULL DEFAULT 'menunggu_verifikasi',
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_dokumen_folder` (`folder_id`),
  KEY `idx_dokumen_user` (`user_id`),
  KEY `idx_dokumen_status` (`status`),
  KEY `idx_dokumen_created` (`created_at`),
  CONSTRAINT `fk_dokumen_kategori` FOREIGN KEY (`kategori_id`)
    REFERENCES `kategori_dokumen`(`id`) ON DELETE RESTRICT ON UPDATE CASCADE,
  CONSTRAINT `fk_dokumen_folder` FOREIGN KEY (`folder_id`)
    REFERENCES `folder`(`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_dokumen_user` FOREIGN KEY (`user_id`)
    REFERENCES `users`(`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Tabel verifikasi
CREATE TABLE `verifikasi` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `dokumen_id` INT UNSIGNED NOT NULL,
  `verifikator_id` INT UNSIGNED NULL,
  `status` ENUM('disetujui','ditolak') NOT NULL,
  `catatan` TEXT NULL,
  `tanggal_verifikasi` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_verifikasi_dokumen` (`dokumen_id`),
  KEY `idx_verifikasi_verifikator` (`verifikator_id`),
  CONSTRAINT `fk_verifikasi_dokumen` FOREIGN KEY (`dokumen_id`)
    REFERENCES `dokumen`(`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_verifikasi_verifikator` FOREIGN KEY (`verifikator_id`)
    REFERENCES `users`(`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Tabel log_aktivitas
CREATE TABLE `log_aktivitas` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` INT UNSIGNED NULL,
  `aktivitas` VARCHAR(255) NOT NULL,
  `detail` TEXT NULL,
  `ip_address` VARCHAR(45) NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_log_user` (`user_id`),
  KEY `idx_log_created` (`created_at`),
  CONSTRAINT `fk_log_user` FOREIGN KEY (`user_id`)
    REFERENCES `users`(`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Tabel user_otp (untuk OTP dan kolom dinamis dari config)
CREATE TABLE `user_otp` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` INT UNSIGNED NOT NULL,
  `otp_hash` VARCHAR(255) NOT NULL,
  `otp_enc` VARCHAR(128) NULL,
  `otp_iv` VARCHAR(32) NULL,
  `otp_tag` VARCHAR(32) NULL,
  `expires_at` TIMESTAMP NOT NULL,
  `attempts` INT DEFAULT 0,
  `last_sent_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `resend_count` INT DEFAULT 0,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_user_otp_user` (`user_id`),
  KEY `idx_user_otp_expires` (`expires_at`),
  CONSTRAINT `fk_user_otp_user` FOREIGN KEY (`user_id`)
    REFERENCES `users`(`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Seed kategori
INSERT INTO `kategori_dokumen` (`id`, `nama_kategori`, `tipe`) VALUES
  (1, 'Data Dinamis', 'dinamis'),
  (2, 'Data Statis', 'statis');

-- Seed users (contoh)
INSERT INTO `users` (`username`, `password`, `nama_lengkap`, `email`, `role`, `status`) VALUES
  ('root', '$2y$10$CKtmSU5nxiefclgXJo7hhe.C3UZmP40JisOSi8KuCGHPMY.OJ6DTy', 'Root User', 'root@example.com', 'root', 1),
  ('admin', '$2y$10$CKtmSU5nxiefclgXJo7hhe.C3UZmP40JisOSi8KuCGHPMY.OJ6DTy', 'Administrator', 'admin@example.com', 'administrator', 1),
  ('verifikator1', '$2y$10$6c/pk/rqAwew0GkKa7LVQua5uj5GI84D8zUqnOcQgh8MUJfyo0UZ2', 'Verifikator Satu', 'verifikator1@example.com', 'verifikator', 1),
  ('pendidik1', '$2y$10$6c/pk/rqAwew0GkKa7LVQua5uj5GI84D8zUqnOcQgh8MUJfyo0UZ2', 'Pendidik Satu', 'pendidik1@example.com', 'pendidik', 1);

-- Seed folder (contoh)
INSERT INTO `folder` (`kategori_id`, `nama_folder`) VALUES
  (1, 'NRG'),
  (1, 'SKP Tahun 2025'),
  (2, 'Sertifikat Pendidik');