<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>e-File SMK Negeri 1 Salam</title>
    <!-- Preconnect & DNS Prefetch untuk CDN agar pengambilan resource lebih cepat -->
    <link rel="preconnect" href="https://cdn.jsdelivr.net" crossorigin>
    <link rel="preconnect" href="https://cdnjs.cloudflare.com" crossorigin>
    <link rel="dns-prefetch" href="//cdn.jsdelivr.net">
    <link rel="dns-prefetch" href="//cdnjs.cloudflare.com">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome v5 (stabil untuk nama ikon lama seperti fa-*-alt) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?= BASE_URL ?>/assets/css/style.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="<?= BASE_URL ?>">e-File SMK Negeri 1 Salam</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <?php if (isLoggedIn()): ?>
                        <li class="nav-item">
<a class="nav-link" href="<?= BASE_URL ?>/dashboard"><i class="fas fa-tachometer-alt me-1"></i> Dashboard</a>
                        </li>
                        <?php if (hasRole('verifikator')): ?>
                            <li class="nav-item">
<a class="nav-link" href="<?= BASE_URL ?>/pages/verification"><i class="fas fa-clipboard-check me-1"></i> Verifikasi</a>
                            </li>
                        <?php endif; ?>
                        <li class="nav-item">
<a class="nav-link" href="<?= BASE_URL ?>/pages/data_dinamis"><i class="fas fa-layer-group me-1"></i> Data Dinamis</a>
                        </li>
                        <li class="nav-item">
<a class="nav-link" href="<?= BASE_URL ?>/pages/data_statis"><i class="fas fa-database me-1"></i> Data Statis</a>
                        </li>
                        <?php if (hasRole('administrator') || hasRole('root')): ?>
                            <li class="nav-item">
<a class="nav-link" href="<?= BASE_URL ?>/pages/users"><i class="fas fa-users me-1"></i> Pengguna</a>
                            </li>
                        <?php endif; ?>
                        <?php if (hasRole('root')): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= BASE_URL ?>/pages/activity"><i class="fas fa-clipboard-list me-1"></i> Aktivitas</a>
                            </li>
                        <?php endif; ?>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                                <?= htmlspecialchars($_SESSION['user_name'] ?? '', ENT_QUOTES, 'UTF-8') ?>
                            </a>
                            <ul class="dropdown-menu">
<li><a class="dropdown-item" href="<?= BASE_URL ?>/pages/profile"><i class="fas fa-user-circle me-1"></i> Profil</a></li>
                                <li><hr class="dropdown-divider"></li>
<li><a class="dropdown-item" href="<?= BASE_URL ?>/logout"><i class="fas fa-sign-out-alt me-1"></i> Logout</a></li>
                            </ul>
                        </li>
                    <?php else: ?>
                        <li class="nav-item">
<a class="nav-link" href="<?= BASE_URL ?>/login"><i class="fas fa-sign-in-alt me-1"></i> Login</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>
    <div class="container-lg mt-4">
        <div class="row gx-3">
            <!-- Konten utama penuh, tanpa sidebar kiri -->
            <main class="col-12">
        <?php if (isset($_SESSION['alert'])): ?>
            <?php 
            $alert = $_SESSION['alert'];
            if (is_array($alert)) {
                $message = $alert['message'];
                $type = $alert['type'];
            } else {
                $message = $alert;
                $type = isset($_SESSION['alert_type']) ? $_SESSION['alert_type'] : 'info';
            }
            ?>
            <div class="alert alert-<?= $type ?> alert-dismissible fade show">
                <?= htmlspecialchars($message, ENT_QUOTES, 'UTF-8') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php unset($_SESSION['alert'], $_SESSION['alert_type']); ?>
        <?php endif; ?>