<?php
require_once '../config/config.php';
require_once '../config/database.php';

// Hanya root yang boleh mengakses halaman aktivitas
if (!isLoggedIn() || !hasRole('root')) {
    setAlert('Anda tidak memiliki akses ke halaman aktivitas', 'danger');
    redirect('/login');
    exit;
}

// Pencarian dan pagination
$q = isset($_GET['q']) ? trim($_GET['q']) : '';
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$perPage = 15;
$offset = ($page - 1) * $perPage;

// Hitung total baris
$countSql = "SELECT COUNT(*) AS total
             FROM log_aktivitas la
             LEFT JOIN users u ON la.user_id = u.id
             WHERE (? = ''
                    OR la.aktivitas LIKE ?
                    OR la.detail LIKE ?
                    OR la.ip_address LIKE ?
                    OR u.username LIKE ?
                    OR u.nama_lengkap LIKE ?)";
$stmtCount = $conn->prepare($countSql);
if (!$stmtCount) { die('Query error: ' . $conn->error); }
$like = '%' . $q . '%';
$stmtCount->bind_param('ssssss', $q, $like, $like, $like, $like, $like);
$stmtCount->execute();
$resCount = $stmtCount->get_result();
$totalRows = $resCount ? ((int)$resCount->fetch_assoc()['total']) : 0;
$stmtCount->close();
$totalPages = max(1, (int)ceil($totalRows / $perPage));
// Clamp halaman agar tidak melewati batas
if ($page > $totalPages) { 
    $page = $totalPages; 
    $offset = ($page - 1) * $perPage; 
}

// Ambil data halaman
$dataSql = "SELECT la.id, la.user_id, la.aktivitas, la.detail, la.ip_address, la.created_at, u.username, u.nama_lengkap
            FROM log_aktivitas la
            LEFT JOIN users u ON la.user_id = u.id
            WHERE (? = ''
                   OR la.aktivitas LIKE ?
                   OR la.detail LIKE ?
                   OR la.ip_address LIKE ?
                   OR u.username LIKE ?
                   OR u.nama_lengkap LIKE ?)
            ORDER BY la.id DESC
            LIMIT ? OFFSET ?";
$stmtData = $conn->prepare($dataSql);
if (!$stmtData) { die('Query error: ' . $conn->error); }
$stmtData->bind_param('ssssssii', $q, $like, $like, $like, $like, $like, $perPage, $offset);
$stmtData->execute();
$resData = $stmtData->get_result();
$logs = $resData ? $resData->fetch_all(MYSQLI_ASSOC) : [];
$stmtData->close();

$pageTitle = 'Aktivitas';
include '../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0"><i class="fas fa-clipboard-list"></i> Aktivitas</h2>
    <a href="<?= BASE_URL ?>/dashboard" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Kembali</a>
    </div>

<div class="row mb-3">
    <div class="col-12">
        <form method="get" action="<?= BASE_URL ?>/pages/activity" class="d-flex gap-2">
            <input type="text" name="q" value="<?= htmlspecialchars($q, ENT_QUOTES, 'UTF-8') ?>" class="form-control" placeholder="Cari Aktivitas, Pengguna atau IP Address">
            <button type="submit" class="btn btn-primary"><i class="fas fa-search"></i></button>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Tanggal</th>
                        <th>Pengguna</th>
                        <th>Aktivitas</th>
                        <th>IP Address</th>
                        <th>Detail</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($logs) > 0): ?>
                        <?php $no = $offset + 1; foreach ($logs as $lg): ?>
                            <tr>
                                <td><?= $no++ ?></td>
                                <td><?= htmlspecialchars(date('d/m/Y H:i', strtotime($lg['created_at'])), ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($lg['nama_lengkap'] ?: ($lg['username'] ?: '-'), ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($lg['aktivitas'], ENT_QUOTES, 'UTF-8') ?></td>
                                <td><?= htmlspecialchars($lg['ip_address'] ?: '-', ENT_QUOTES, 'UTF-8') ?></td>
                                <td class="text-break" style="max-width:380px;">
                                    <?= nl2br(htmlspecialchars($lg['detail'] ?: '-', ENT_QUOTES, 'UTF-8')) ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center">Tidak ada aktivitas ditemukan</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php 
            $base = BASE_URL . '/pages/activity?';
            $qs = [];
            if ($q !== '') { $qs['q'] = $q; }
            $build = function($p) use ($base, $qs) {
                $qs['page'] = $p;
                return $base . http_build_query($qs);
            };
            echo render_pagination($page, $totalPages, $build, 'Navigasi halaman');
        ?>
    </div>
</div>

<?php include '../includes/footer.php'; ?>