<?php
require_once '../config/config.php';
require_once '../config/database.php';

// Cek login dan role
if (!isLoggedIn()) {
    setAlert('Silakan login terlebih dahulu', 'danger');
    redirect('/login');
    exit;
}

// Ambil data folder untuk kategori Data Dinamis
$kategori_id = 1; // ID untuk Data Dinamis
// Pencarian dan pagination
$q = isset($_GET['q']) ? trim($_GET['q']) : '';
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$perPage = 12;
$offset = ($page - 1) * $perPage;

// Hitung total
$count_sql = "SELECT COUNT(*) as total
              FROM folder f
              WHERE f.kategori_id = ?" . ($q !== '' ? " AND f.nama_folder LIKE ?" : "");
$stmtCount = $conn->prepare($count_sql);
if ($q !== '') {
    $like = '%' . $q . '%';
    $stmtCount->bind_param("is", $kategori_id, $like);
} else {
    $stmtCount->bind_param("i", $kategori_id);
}
$stmtCount->execute();
$totalRows = $stmtCount->get_result()->fetch_assoc()['total'] ?? 0;
$totalPages = max(1, (int)ceil($totalRows / $perPage));
// Clamp halaman agar tidak melewati batas dan sesuaikan offset
if ($page > $totalPages) {
    $page = $totalPages;
    $offset = ($page - 1) * $perPage;
}

// Query data halaman
if ($q !== '') {
    $role = $_SESSION['user_role'] ?? '';
    $userId = (int)($_SESSION['user_id'] ?? 0);
    if ($role === 'pendidik') {
        $folder_query = "SELECT f.id, f.nama_folder, (
                            SELECT COUNT(d.id) FROM dokumen d WHERE d.folder_id = f.id AND d.user_id = ? AND d.status = 'diverifikasi'
                         ) as jumlah_dokumen
                         FROM folder f
                         WHERE f.kategori_id = ? AND f.nama_folder LIKE ?
                         ORDER BY f.nama_folder ASC LIMIT ? OFFSET ?";
        $stmt = $conn->prepare($folder_query);
        $like = '%' . $q . '%';
        $stmt->bind_param("iisii", $userId, $kategori_id, $like, $perPage, $offset);
    } else {
        $folder_query = "SELECT f.id, f.nama_folder, (
                            SELECT COUNT(d.id) FROM dokumen d WHERE d.folder_id = f.id
                         ) as jumlah_dokumen
                         FROM folder f
                         WHERE f.kategori_id = ? AND f.nama_folder LIKE ?
                         ORDER BY f.nama_folder ASC LIMIT ? OFFSET ?";
        $stmt = $conn->prepare($folder_query);
        $like = '%' . $q . '%';
        $stmt->bind_param("isii", $kategori_id, $like, $perPage, $offset);
    }
    $stmt->execute();
    $folder_result = $stmt->get_result();
} else {
    $role = $_SESSION['user_role'] ?? '';
    $userId = (int)($_SESSION['user_id'] ?? 0);
    if ($role === 'pendidik') {
        $folder_query = "SELECT f.id, f.nama_folder, (
                            SELECT COUNT(d.id) FROM dokumen d WHERE d.folder_id = f.id AND d.user_id = ? AND d.status = 'diverifikasi'
                         ) as jumlah_dokumen
                         FROM folder f
                         WHERE f.kategori_id = ?
                         ORDER BY f.nama_folder ASC LIMIT ? OFFSET ?";
        $stmt = $conn->prepare($folder_query);
        $stmt->bind_param("iiii", $userId, $kategori_id, $perPage, $offset);
    } else {
        $folder_query = "SELECT f.id, f.nama_folder, (
                            SELECT COUNT(d.id) FROM dokumen d WHERE d.folder_id = f.id
                         ) as jumlah_dokumen
                         FROM folder f
                         WHERE f.kategori_id = ?
                         ORDER BY f.nama_folder ASC LIMIT ? OFFSET ?";
        $stmt = $conn->prepare($folder_query);
        $stmt->bind_param("iii", $kategori_id, $perPage, $offset);
    }
    $stmt->execute();
    $folder_result = $stmt->get_result();
}

// Header
$pageTitle = "Data Dinamis";
include '../includes/header.php';
?>

<div class="row mb-4">
    <div class="col-md-12">
        <div class="row align-items-center mb-2">
            <div class="col-md-8">
                <h2 class="mb-0"><i class="fas fa-database"></i> Data Dinamis</h2>
            </div>
            <div class="col-md-4">
                <form method="get" action="" class="d-flex gap-2">
                    <input type="text" name="q" class="form-control" placeholder="Cari Folder" value="<?= htmlspecialchars($q) ?>">
                    <button class="btn btn-primary" type="submit"><i class="fas fa-search"></i></button>
                </form>
            </div>
        </div>
        <?php if (hasRole('administrator') || hasRole('root')): ?>
        <div class="mb-2">
            <a href="<?= BASE_URL ?>/pages/folders?kategori_id=1" class="btn btn-success"><i class="fas fa-folder-plus"></i> Tambah Folder Baru</a>
        </div>
        <?php endif; ?>
        <hr>
    </div>
 </div>

<div class="row">
    <?php if ($folder_result->num_rows > 0): ?>
        <?php while ($folder = $folder_result->fetch_assoc()): ?>
            <div class="col-md-4 mb-4">
                <div class="card h-100">
                    <div class="card-header bg-info text-white">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-folder"></i> <?= htmlspecialchars($folder['nama_folder']) ?>
                        </h5>
                    </div>
                    <div class="card-body">
                        <p class="card-text">
                            <i class="fas fa-file-alt"></i> <?= $folder['jumlah_dokumen'] ?> dokumen
                        </p>
                        <a href="<?= BASE_URL ?>/pages/documents?folder_id=<?= $folder['id'] ?>" class="btn btn-primary">
                            <i class="fas fa-eye"></i> Lihat Dokumen
                        </a>
                        <?php if ((($_SESSION['user_role'] ?? '') === 'pendidik') || hasRole('administrator') || hasRole('root')): ?>
                        <a href="<?= BASE_URL ?>/pages/upload?folder_id=<?= $folder['id'] ?>" class="btn btn-success">
                            <i class="fas fa-upload"></i> Upload
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
    <?php else: ?>
        <div class="col-md-12">
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i> Belum ada folder yang dibuat untuk kategori Data Dinamis.
                <?php if (hasRole('administrator') || hasRole('root')): ?>
                    <a href="<?= BASE_URL ?>/pages/folders?kategori_id=1" class="alert-link">Klik di sini</a> untuk membuat folder baru.
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php if ($totalPages > 1): ?>
<?php
  $base = BASE_URL . '/pages/data_dinamis?';
  $qs = [];
  if ($q !== '') { $qs['q'] = $q; }
  $build = function($p) use ($base, $qs) {
      $qs['page'] = $p;
      return $base . http_build_query($qs);
  };
  echo render_pagination($page, $totalPages, $build, 'Navigasi halaman');
?>
<?php endif; ?>

<?php
include '../includes/footer.php';
?>