<?php
require_once '../config/config.php';
require_once '../config/database.php';

// Halaman daftar dokumen per folder, terbuka untuk pengguna login.
if (!isLoggedIn()) {
    // Tetap izinkan akses jika ingin publik, untuk saat ini arahkan ke login
    redirect('/login');
}

$folder_id = isset($_GET['folder_id']) ? (int)$_GET['folder_id'] : 0;

if ($folder_id > 0) {
    // Mode folder tertentu
    $stmt = $conn->prepare("SELECT f.id, f.nama_folder, f.kategori_id FROM folder f WHERE f.id = ?");
    $stmt->bind_param("i", $folder_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if (!$result || $result->num_rows == 0) {
        setAlert('Folder tidak ditemukan', 'danger');
    redirect('/dashboard');
    }
    $folder = $result->fetch_assoc();

    // Aksi hapus dokumen (khusus admin/root) di mode folder
    if ((hasRole('administrator') || hasRole('root')) && isset($_GET['delete']) && is_numeric($_GET['delete'])) {
        $tok = $_GET['csrf'] ?? '';
        if (!verify_csrf($tok)) {
            setAlert('Sesi tidak valid. Silakan muat ulang halaman.', 'danger');
            redirect('/pages/documents?folder_id=' . $folder_id);
        }
        $docIdDel = (int)$_GET['delete'];
        // Ambil dokumen untuk memastikan berada di folder saat ini
        $stmtD = $conn->prepare("SELECT id, file_path FROM dokumen WHERE id = ? AND folder_id = ? LIMIT 1");
        $stmtD->bind_param("ii", $docIdDel, $folder_id);
        $stmtD->execute();
        $resD = $stmtD->get_result();
        $stmtD->close();
        if ($resD && $resD->num_rows === 1) {
            $docRow = $resD->fetch_assoc();
            // Hapus file fisik
            if (!empty($docRow['file_path'])) {
                $abs = dirname(__DIR__) . '/' . $docRow['file_path'];
                if (file_exists($abs)) { @unlink($abs); }
            }
            // Hapus catatan verifikasi terlebih dahulu (untuk kompatibilitas jika FK tidak cascade)
            $stmtV = $conn->prepare("DELETE FROM verifikasi WHERE dokumen_id = ?");
            $stmtV->bind_param("i", $docIdDel);
            @$stmtV->execute();
            @$stmtV->close();
            // Hapus dokumen
            $stmtDel = $conn->prepare("DELETE FROM dokumen WHERE id = ?");
            $stmtDel->bind_param("i", $docIdDel);
            if ($stmtDel->execute()) {
                setAlert('Dokumen berhasil dihapus', 'success');
                logActivity('Menghapus dokumen', 'doc_id=' . $docIdDel . ', folder=' . $folder['nama_folder']);
            } else {
                setAlert('Gagal menghapus dokumen: ' . $conn->error, 'danger');
            }
            $stmtDel->close();
        } else {
            setAlert('Dokumen tidak ditemukan di folder ini', 'warning');
        }
        redirect('/pages/documents?folder_id=' . $folder_id);
    }

    // Tentukan visibilitas tombol Upload pada mode folder
    $canUploadForFolder = true;
    $roleCurrent = $_SESSION['user_role'] ?? '';
    $uidCurrent = isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : 0;
    if ($uidCurrent > 0 && ($roleCurrent === 'pendidik' || $roleCurrent === 'verifikator')) {
        // Jika sudah ada dokumen yang diverifikasi milik pengguna ini di folder, sembunyikan tombol upload
        $stmtUp = $conn->prepare("SELECT COUNT(*) as total FROM dokumen WHERE folder_id = ? AND user_id = ? AND status = 'diverifikasi'");
        $stmtUp->bind_param("ii", $folder_id, $uidCurrent);
        $stmtUp->execute();
        $canUploadForFolder = (($stmtUp->get_result()->fetch_assoc()['total'] ?? 0) == 0);
        $stmtUp->close();
    }
    // Filter sesuai role saat melihat isi folder
    $role = $_SESSION['user_role'] ?? '';
    if ($role === 'pendidik') {
        // Pendidik hanya melihat dokumen milik sendiri dalam folder ini
        $stmt = $conn->prepare("SELECT d.id, d.judul, d.deskripsi, d.file_path, d.status, d.created_at, d.user_id,
                                       v.status AS ver_status, v.catatan, v.tanggal_verifikasi AS ver_tanggal, uv.nama_lengkap AS verifikator_nama
                                FROM dokumen d
                                LEFT JOIN verifikasi v ON v.dokumen_id = d.id AND v.id = (
                                    SELECT MAX(vv.id) FROM verifikasi vv WHERE vv.dokumen_id = d.id
                                )
                                LEFT JOIN users uv ON uv.id = v.verifikator_id
                                WHERE d.folder_id = ? AND d.user_id = ?
                                ORDER BY d.created_at DESC");
        $uid = (int)$_SESSION['user_id'];
        $stmt->bind_param("ii", $folder_id, $uid);
        $stmt->execute();
        $docs = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    } elseif ($role === 'verifikator') {
        // Verifikator melihat semua dokumen diverifikasi pada folder ini
        $stmt = $conn->prepare("SELECT d.id, d.judul, d.deskripsi, d.file_path, d.status, d.created_at, d.user_id,
                                       v.status AS ver_status, v.catatan, v.tanggal_verifikasi AS ver_tanggal, uv.nama_lengkap AS verifikator_nama
                                FROM dokumen d
                                LEFT JOIN verifikasi v ON v.dokumen_id = d.id AND v.id = (
                                    SELECT MAX(vv.id) FROM verifikasi vv WHERE vv.dokumen_id = d.id
                                )
                                LEFT JOIN users uv ON uv.id = v.verifikator_id
                                WHERE d.folder_id = ? AND d.status = 'diverifikasi'
                                ORDER BY d.created_at DESC");
        $stmt->bind_param("i", $folder_id);
        $stmt->execute();
        $docs = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    } else {
        // Administrator dan root melihat semua dokumen dalam folder ini
        $stmt = $conn->prepare("SELECT d.id, d.judul, d.deskripsi, d.file_path, d.status, d.created_at, d.user_id,
                                       v.status AS ver_status, v.catatan, v.tanggal_verifikasi AS ver_tanggal, uv.nama_lengkap AS verifikator_nama
                                FROM dokumen d
                                LEFT JOIN verifikasi v ON v.dokumen_id = d.id AND v.id = (
                                    SELECT MAX(vv.id) FROM verifikasi vv WHERE vv.dokumen_id = d.id
                                )
                                LEFT JOIN users uv ON uv.id = v.verifikator_id
                                WHERE d.folder_id = ?
                                ORDER BY d.created_at DESC");
        $stmt->bind_param("i", $folder_id);
        $stmt->execute();
        $docs = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    }
    $pageTitle = 'Dokumen - ' . htmlspecialchars($folder['nama_folder']);
} else {
    // Mode umum: tanpa folder, tampilkan semua dokumen sesuai role dengan pagination dan pencarian
    $role = $_SESSION['user_role'];
    $search = isset($_GET['q']) ? trim($_GET['q']) : '';
    $page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
    $perPage = 15;
    $offset = ($page - 1) * $perPage;

    $whereParts = [];
    $params = [];
    $types = '';

    if (!empty($search)) {
        $whereParts[] = 'd.judul LIKE ?';
        $params[] = '%' . $search . '%';
        $types .= 's';
    }

    if ($role === 'administrator' || $role === 'root') {
        // Tidak ada filter tambahan
    } elseif ($role === 'verifikator') {
        $whereParts[] = "d.status = 'diverifikasi'";
    } else {
        $whereParts[] = 'd.user_id = ?';
        $params[] = (int)$_SESSION['user_id'];
        $types .= 'i';
    }

    $whereSql = count($whereParts) ? ('WHERE ' . implode(' AND ', $whereParts)) : '';

    // Hitung total untuk pagination
    $countSql = "SELECT COUNT(*) AS total FROM dokumen d $whereSql";
    $stmtCount = $conn->prepare($countSql);
    if ($types !== '') { $stmtCount->bind_param($types, ...$params); }
    $stmtCount->execute();
    $totalRows = ($stmtCount->get_result()->fetch_assoc()['total'] ?? 0);
    $stmtCount->close();
    $totalPages = max(1, (int)ceil($totalRows / $perPage));
    // Clamp halaman agar tidak melewati batas dan sesuaikan offset
    if ($page > $totalPages) {
        $page = $totalPages;
        $offset = ($page - 1) * $perPage;
    }

    // Query data dengan limit
    $sql = "SELECT d.id, d.judul, d.deskripsi, d.file_path, d.status, d.created_at, d.user_id, f.nama_folder,
                   v.status AS ver_status, v.catatan, v.tanggal_verifikasi AS ver_tanggal, uv.nama_lengkap AS verifikator_nama
            FROM dokumen d
            LEFT JOIN folder f ON d.folder_id = f.id
            LEFT JOIN verifikasi v ON v.dokumen_id = d.id AND v.id = (
                SELECT MAX(vv.id) FROM verifikasi vv WHERE vv.dokumen_id = d.id
            )
            LEFT JOIN users uv ON uv.id = v.verifikator_id
            $whereSql
            ORDER BY d.created_at DESC
            LIMIT ? OFFSET ?";
    $stmtData = $conn->prepare($sql);
    $bindTypes = $types . 'ii';
    $bindParams = $params;
    $bindParams[] = $perPage;
    $bindParams[] = $offset;
    $stmtData->bind_param($bindTypes, ...$bindParams);
    $stmtData->execute();
    $result = $stmtData->get_result();
    $docs = $result ? $result->fetch_all(MYSQLI_ASSOC) : [];
    $stmtData->close();

    $pageTitle = 'Semua Dokumen';
}
include '../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><?= isset($folder) ? ('Dokumen - ' . htmlspecialchars($folder['nama_folder'])) : 'Semua Dokumen' ?></h2>
    <div>
        <?php if (isset($folder) && ((($_SESSION['user_role'] ?? '') === 'pendidik') || hasRole('administrator') || hasRole('root')) && ($canUploadForFolder ?? true)): ?>
            <a href="<?= BASE_URL ?>/pages/upload?folder_id=<?= $folder_id ?>" class="btn btn-success">
                <i class="fas fa-upload"></i> Upload
            </a>
        <?php endif; ?>
        <?php if (isset($folder) && (hasRole('administrator') || hasRole('root'))): ?>
            <a href="<?= BASE_URL ?>/pages/download_folder?folder_id=<?= (int)$folder_id ?>" class="btn btn-outline-primary">
                <i class="fas fa-download"></i> Download Semua
            </a>
        <?php endif; ?>
        <?php
    $backUrl = BASE_URL . '/dashboard';
            if (isset($folder) && isset($folder['kategori_id'])) {
    $backUrl = BASE_URL . (($folder['kategori_id'] == 1) ? '/pages/data_dinamis' : '/pages/data_statis');
            }
        ?>
        <a href="<?= $backUrl ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>
    </div>

<?php if (!isset($folder)): ?>
<div class="row align-items-center mb-3">
    <div class="col-md-8"></div>
    <div class="col-md-4">
        <form method="get" action="" class="d-flex gap-2">
            <input type="text" name="q" value="<?= htmlspecialchars($search ?? '') ?>" class="form-control" placeholder="Cari Nama File">
            <button class="btn btn-primary" type="submit"><i class="fas fa-search"></i></button>
            <?php if ($page > 1): ?><input type="hidden" name="page" value="<?= (int)$page ?>"><?php endif; ?>
        </form>
    </div>
</div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Judul</th>
                        
                        <th>Status</th>
                        <th>Verifikator</th>
                        <th>Catatan</th>
                        <th>Waktu Upload</th>
                        <th>Waktu Verifikasi</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($docs) > 0): ?>
                        <?php $rowIndex = 0; foreach ($docs as $d): $rowNo = ($rowIndex++) + (($offset ?? 0) + 1); ?>
                            <tr>
                                <td><?= $rowNo ?></td>
                                <td><?= htmlspecialchars($d['judul']) ?></td>
                                
                                <td>
                                    <span class="badge bg-<?=
                                        $d['status'] == 'diverifikasi' ? 'success' : (
                                        $d['status'] == 'menunggu_verifikasi' ? 'warning' : 'danger'
                                    )?>">
                                        <?= ucfirst(str_replace('_',' ', $d['status'])) ?>
                                    </span>
                                </td>
                                <td>
                                    <?php if ($d['status'] === 'diverifikasi' || $d['status'] === 'ditolak'): ?>
                                        <?= htmlspecialchars($d['verifikator_nama'] ?? '-') ?>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($d['status'] === 'diverifikasi' || $d['status'] === 'ditolak'): ?>
                                        <?= htmlspecialchars($d['catatan'] ?? '-') ?>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td><?= date('d/m/Y H:i', strtotime($d['created_at'])) ?></td>
                                <td><?= !empty($d['ver_tanggal']) ? date('d/m/Y H:i', strtotime($d['ver_tanggal'])) : '-' ?></td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group" aria-label="Aksi Dokumen">
                                        <?php if (!empty($d['id'])): ?>
                                            <a href="<?= BASE_URL ?>/pages/preview?id=<?= (int)$d['id'] ?>" class="btn btn-info btn-action preview-pdf">
                                                <i class="fas fa-eye"></i> Lihat
                                            </a>
                                        <?php endif; ?>
                                        <?php
                                            $isOwner = isset($_SESSION['user_id']) && isset($d['user_id']) && ((int)$d['user_id'] === (int)$_SESSION['user_id']);
                                            if ($isOwner && hasRole('pendidik') && $d['status'] === 'draft' && isset($folder_id) && $folder_id > 0): ?>
                                                <a href="<?= BASE_URL ?>/pages/upload?folder_id=<?= (int)$folder_id ?>&replace=1" class="btn btn-warning">
                                                    <i class="fas fa-redo"></i> Unggah Ulang
                                                </a>
                                        <?php endif; ?>
                                        <?php if (isset($folder_id) && ($d['id'] ?? 0) && (hasRole('administrator') || hasRole('root'))): ?>
                                            <a href="<?= BASE_URL ?>/pages/documents?folder_id=<?= (int)$folder_id ?>&delete=<?= (int)$d['id'] ?>&csrf=<?= csrf_token() ?>" class="btn btn-danger btn-action btn-delete" title="Hapus" data-confirm-message="Apakah Anda yakin ingin menghapus dokumen ini? Tindakan ini tidak dapat dibatalkan.">
                                                <i class="fas fa-trash"></i> Hapus
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6" class="text-center">Belum ada dokumen</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php if (!isset($folder) && $totalPages > 1): ?>
<?php 
    $base = BASE_URL . '/pages/documents?';
    $qs = [];
    if (!empty($search)) { $qs['q'] = $search; }
    $build = function($p) use ($base, $qs) {
        $qs['page'] = $p;
        return $base . http_build_query($qs);
    };
    echo render_pagination($page, $totalPages, $build, 'Navigasi halaman');
?>
<?php endif; ?>

<?php include '../includes/footer.php'; ?>