<?php
require_once '../config/config.php';
require_once '../config/database.php';

if (!isLoggedIn()) {
redirect('/login');
}

$user_id = (int)$_SESSION['user_id'];
$stmt = $conn->prepare("SELECT id, username, nama_lengkap, email, role, status, created_at, updated_at FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
if (!$result || $result->num_rows === 0) {
    setAlert('Akun tidak ditemukan', 'danger');
redirect('/dashboard');
}
$user = $result->fetch_assoc();

$pageTitle = 'Profil Akun';
include '../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>Profil Akun</h2>
<a href="<?= BASE_URL ?>/dashboard" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Kembali
    </a>
</div>

<div class="card">
    <div class="card-body">
        <div class="row mb-3">
            <div class="col-md-6">
                <label class="form-label">Nama Lengkap</label>
                <input type="text" class="form-control" value="<?= htmlspecialchars($user['nama_lengkap']) ?>" readonly>
            </div>
            <div class="col-md-6">
                <label class="form-label">Email</label>
                <input type="text" class="form-control" value="<?= htmlspecialchars($user['email']) ?>" readonly>
            </div>
        </div>
        <div class="row mb-3">
            <div class="col-md-6">
                <label class="form-label">Username</label>
                <input type="text" class="form-control" value="<?= htmlspecialchars($user['username']) ?>" readonly>
            </div>
            <div class="col-md-3">
                <label class="form-label">Role</label>
                <input type="text" class="form-control" value="<?= $user['role'] == 'root' ? 'Root (Super Administrator)' : ucfirst($user['role']) ?>" readonly>
            </div>
            <div class="col-md-3">
                <label class="form-label">Status</label>
                <input type="text" class="form-control" value="<?= $user['status'] == 1 ? 'Aktif' : 'Nonaktif' ?>" readonly>
            </div>
        </div>
        <div class="row mb-3">
            <div class="col-md-6">
                <label class="form-label">Dibuat</label>
                <input type="text" class="form-control" value="<?= date('d/m/Y H:i', strtotime($user['created_at'])) ?>" readonly>
            </div>
            <div class="col-md-6">
                <label class="form-label">Diperbarui</label>
                <input type="text" class="form-control" value="<?= date('d/m/Y H:i', strtotime($user['updated_at'])) ?>" readonly>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>