<?php
require_once 'config/config.php';
require_once 'config/database.php';

// Redirect jika sudah login
if (isLoggedIn()) {
redirect('/dashboard');
}

$error = '';

// Proses login
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // CSRF validation
    $token = $_POST['csrf_token'] ?? '';
    if (!verify_csrf($token)) {
        $error = 'Sesi tidak valid. Silakan muat ulang halaman.';
    } else {
    $username = sanitize($_POST['username']);
    $password = $_POST['password'];
    
    if (empty($username) || empty($password)) {
        $error = 'Username dan password harus diisi';
    } else {
        // Query untuk mencari user
        $stmt = $conn->prepare("SELECT id, username, password, nama_lengkap, email, role, status FROM users WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows == 1) {
            $user = $result->fetch_assoc();
            
            // Verifikasi password
            if (password_verify($password, $user['password'])) {
                // Cek status user
                if ($user['status'] == 1) {
                    // Untuk role pendidik, wajib OTP email sebelum login penuh
                    if ($user['role'] === 'pendidik') {
                        // Buat OTP dan kirim email
                        $code = createOtpForUser((int)$user['id']);
                        sendOtpEmail($user['email'], $code);
                        markOtpSent((int)$user['id']);
                        // Simpan sesi pending OTP
                        $_SESSION['pending_otp_user_id'] = (int)$user['id'];
                        $_SESSION['pending_otp_username'] = $user['username'];
                        // Info ke user
                        setAlert('Kode OTP telah dikirim ke email terdaftar. Masukkan kode untuk melanjutkan.', 'info');
                        // Redirect ke verifikasi OTP (extensionless agar konsisten dengan .htaccess)
                        redirect('/pages/verify_otp');
                    } else {
                        // Login penuh untuk role selain pendidik
                        $_SESSION['user_id'] = $user['id'];
                        $_SESSION['user_username'] = $user['username'];
                        $_SESSION['user_name'] = $user['nama_lengkap'];
                        $_SESSION['user_email'] = $user['email'];
                        $_SESSION['user_role'] = $user['role'];
                        // Set token sesi tunggal (single device)
                        setUserSessionToken((int)$user['id']);
                        session_regenerate_id(true);
                        try {
                            $ustmt = $conn->prepare("UPDATE users SET last_login = CURRENT_TIMESTAMP WHERE id = ?");
                            $ustmt->bind_param("i", $user['id']);
                            $ustmt->execute();
                            $ustmt->close();
                        } catch (Exception $e) {}
                        $aktivitas = "Login ke sistem";
                        $ip = $_SERVER['REMOTE_ADDR'];
                        $stmt = $conn->prepare("INSERT INTO log_aktivitas (user_id, aktivitas, ip_address) VALUES (?, ?, ?)");
                        $stmt->bind_param("iss", $user['id'], $aktivitas, $ip);
                        $stmt->execute();
                        redirect('/dashboard');
                    }
                } else {
                    $error = 'Akun Anda dinonaktifkan. Silakan hubungi administrator.';
                }
            } else {
                $error = 'Password salah';
            }
        } else {
            $error = 'Username tidak ditemukan';
        }
    }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - e-File SMK Negeri 1 Salam</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="bg-light">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <div class="card shadow-sm login-form mt-5">
                    <div class="card-body p-4">
                        <div class="text-center mb-4">
                            <img src="assets/img/logo.png" alt="Logo SMK Negeri 1 Salam" class="login-brand mb-2" style="height:84px;width:auto;">
                            <h5 class="fw-semibold text-primary text-nowrap login-title" style="letter-spacing:0.2px">Manajeman e-File</h5>
                        </div>
                        
                        <?php if (!empty($error)): ?>
                            <div class="alert alert-danger"><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8') ?></div>
                        <?php endif; ?>
                        
                        <form method="POST" action="">
                            <input type="hidden" name="csrf_token" value="<?= csrf_token() ?>">
                            <div class="mb-3">
                                <label for="username" class="form-label">Username</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-user"></i></span>
                                    <input type="text" class="form-control" id="username" name="username" required>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-lock"></i></span>
                                    <input type="password" class="form-control" id="password" name="password" required>
                                </div>
                            </div>
                            
                            <div class="d-grid gap-2 mt-4">
                                <button type="submit" class="btn btn-primary btn-lg">Login</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="text-center mt-3">
                    <p class="mb-0">&copy; <?= date('Y') ?> SMK Negeri 1 Salam</p>
                    <small class="text-muted">Version 2025.01</small>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>