<?php
require_once '../config/config.php';
require_once '../config/database.php';

// Hanya administrator atau root yang boleh mengunduh semua file dalam folder
if (!isLoggedIn() || !(hasRole('administrator') || hasRole('root'))) {
    setAlert('Anda tidak memiliki akses untuk mengunduh folder', 'danger');
redirect('/login');
}

$folder_id = isset($_GET['folder_id']) ? (int)$_GET['folder_id'] : 0;
if ($folder_id <= 0) {
    setAlert('Folder tidak valid', 'warning');
redirect('/dashboard');
}

// Ambil nama folder
$stmt = $conn->prepare("SELECT id, nama_folder FROM folder WHERE id = ?");
$stmt->bind_param('i', $folder_id);
$stmt->execute();
$res = $stmt->get_result();
if (!$res || $res->num_rows === 0) {
    setAlert('Folder tidak ditemukan', 'danger');
redirect('/dashboard');
}
$folder = $res->fetch_assoc();
$stmt->close();

// Ambil semua dokumen dalam folder
$stmt = $conn->prepare("SELECT id, judul, file_path FROM dokumen WHERE folder_id = ? ORDER BY created_at ASC");
$stmt->bind_param('i', $folder_id);
$stmt->execute();
$docs = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

if (!$docs || count($docs) === 0) {
    setAlert('Tidak ada dokumen dalam folder ini', 'warning');
    redirect('/pages/documents.php?folder_id=' . $folder_id);
}

// Buat ZIP sementara
// Guard: pastikan ekstensi ZipArchive tersedia agar tidak fatal error
if (!class_exists('ZipArchive')) {
    setAlert('Fitur ZIP tidak tersedia. Aktifkan ekstensi php_zip pada server Anda.', 'danger');
    redirect('/pages/documents.php?folder_id=' . $folder_id);
}
$zip = new ZipArchive();
$safeName = preg_replace('/[^A-Za-z0-9_\- ]/', '', $folder['nama_folder']);
$timestamp = date('Ymd_His');
$zipFilename = sys_get_temp_dir() . DIRECTORY_SEPARATOR . "folder_{$folder_id}_{$safeName}_{$timestamp}.zip";

if ($zip->open($zipFilename, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== true) {
    setAlert('Gagal membuat arsip ZIP', 'danger');
    redirect('/pages/documents.php?folder_id=' . $folder_id);
}

// Tambahkan file yang ada ke dalam ZIP
$baseDir = dirname(__DIR__);
foreach ($docs as $d) {
    if (empty($d['file_path'])) continue;
    $abs = $baseDir . '/' . $d['file_path'];
    if (!file_exists($abs)) continue;
    // Nama dalam zip: gunakan nama file asli
    $zip->addFile($abs, basename($abs));
}
$zip->close();

// Kirim ZIP ke browser
header('Content-Description: File Transfer');
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="' . basename($zipFilename) . '"');
header('Content-Length: ' . filesize($zipFilename));
header('Pragma: public');
readfile($zipFilename);

// Hapus file temporer
@unlink($zipFilename);
exit;