<?php
require_once '../config/config.php';
require_once '../config/database.php';

// Hanya administrator atau root yang boleh membuat folder
if (!isLoggedIn() || !(hasRole('administrator') || hasRole('root'))) {
    setAlert('Anda tidak memiliki akses ke halaman ini', 'danger');
redirect('/login');
    exit;
}

$error = '';
$success = '';

// Proses tambah folder
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validasi CSRF
    $token = $_POST['csrf_token'] ?? '';
    if (!verify_csrf($token)) {
        $error = 'Sesi tidak valid. Silakan muat ulang halaman dan coba lagi.';
    } else {
    // Normalisasi nama folder: trim, rapikan spasi berlebih
    $nama_folder = sanitize($_POST['nama_folder']);
    $nama_folder = preg_replace('/\s+/u', ' ', trim($nama_folder));
    $tipe = sanitize($_POST['tipe']); // 'dinamis' atau 'statis'

    if (empty($nama_folder) || empty($tipe)) {
        $error = 'Nama folder dan tipe harus diisi';
    } elseif (!in_array($tipe, ['dinamis', 'statis'])) {
        $error = 'Tipe folder tidak valid';
    } else {
        // Ambil kategori_id dari tabel kategori_dokumen berdasarkan tipe
        $stmt = $conn->prepare("SELECT id FROM kategori_dokumen WHERE tipe = ? LIMIT 1");
        $stmt->bind_param("s", $tipe);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows === 0) {
            $error = 'Kategori untuk tipe tersebut belum tersedia';
        } else {
            $kategori = $result->fetch_assoc();
            $kategori_id = (int)$kategori['id'];

            // Cek duplikasi ketat (abaikan perbedaan spasi): tidak boleh sama persis
            $stmt = $conn->prepare("SELECT id FROM folder WHERE REPLACE(nama_folder, ' ', '') = REPLACE(?, ' ', '') AND kategori_id = ?");
            $stmt->bind_param("si", $nama_folder, $kategori_id);
            $stmt->execute();
            $exists = $stmt->get_result()->num_rows > 0;

            if ($exists) {
                $error = 'Nama folder sudah digunakan di kategori ini (tidak boleh sama persis)';
            } else {
                // Insert folder, deteksi apakah kolom created_by tersedia di skema
                $creator_id = (int)($_SESSION['user_id'] ?? 0);
                $colCheck = $conn->query("SHOW COLUMNS FROM folder LIKE 'created_by'");
                $hasCreatedBy = $colCheck && $colCheck->num_rows > 0;
                if ($hasCreatedBy) {
                    $stmt = $conn->prepare("INSERT INTO folder (nama_folder, kategori_id, created_by) VALUES (?, ?, ?)");
                    $stmt->bind_param("sii", $nama_folder, $kategori_id, $creator_id);
                } else {
                    $stmt = $conn->prepare("INSERT INTO folder (nama_folder, kategori_id) VALUES (?, ?)");
                    $stmt->bind_param("si", $nama_folder, $kategori_id);
                }
                if ($stmt && $stmt->execute()) {
                    $success = 'Folder berhasil dibuat';
                    // Redirect ke halaman sesuai tipe
                    if ($tipe === 'dinamis') {
redirect('/pages/data_dinamis');
                    } else {
redirect('/pages/data_statis');
                    }
                    exit;
                } else {
                    $error = 'Gagal membuat folder: ' . ($conn->error ?: 'Kesalahan tak diketahui');
                }
            }
        }
    }
}

// Tutup blok POST jika belum tertutup
}

// Header
$pageTitle = 'Buat Folder';
include '../includes/header.php';
?>

<?php
// Tentukan URL kembali berdasarkan konteks kategori (1=dinamis, 2=statis)
$kategoriContext = isset($_GET['kategori_id']) ? (int)$_GET['kategori_id'] : 0;
$backUrl = BASE_URL . ($kategoriContext === 1 ? '/pages/data_dinamis' : ($kategoriContext === 2 ? '/pages/data_statis' : '/dashboard'));
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>Buat Folder Baru</h2>
    <a href="<?= $backUrl ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Kembali
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if (!empty($error)): ?>
            <div class="alert alert-danger"><?= $error ?></div>
        <?php endif; ?>
        <?php if (!empty($success)): ?>
            <div class="alert alert-success"><?= $success ?></div>
        <?php endif; ?>

        <form method="POST" action="">
            <input type="hidden" name="csrf_token" value="<?= csrf_token() ?>">
            <div class="row mb-3">
                <div class="col-md-6">
                    <label for="nama_folder" class="form-label">Nama Folder</label>
                    <input type="text" class="form-control" id="nama_folder" name="nama_folder" required>
                </div>
                <div class="col-md-6">
                    <label for="tipe" class="form-label">Tipe</label>
                    <select class="form-select" id="tipe" name="tipe" required>
                        <option value="" disabled selected>Pilih tipe</option>
                        <option value="dinamis">Data Dinamis</option>
                        <option value="statis">Data Statis</option>
                    </select>
                </div>
            </div>
            <div class="d-grid gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-folder-plus"></i> Buat Folder
                </button>
            </div>
        </form>
    </div>
</div>

<?php include '../includes/footer.php'; ?>