<?php
require_once '../config/config.php';
require_once '../config/database.php';

// Hanya pengguna login yang boleh mengakses pratinjau
if (!isLoggedIn()) {
    setAlert('Silakan login terlebih dahulu', 'danger');
    redirect('/login');
    exit;
}

// Ambil id dokumen
$doc_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($doc_id <= 0) {
    http_response_code(400);
    echo 'Bad Request';
    exit;
}

// Ambil metadata dokumen
$stmt = $conn->prepare("SELECT d.id, d.user_id, d.file_path, d.file_type, d.status FROM dokumen d WHERE d.id = ? LIMIT 1");
$stmt->bind_param('i', $doc_id);
$stmt->execute();
$res = $stmt->get_result();
if (!$res || $res->num_rows === 0) {
    http_response_code(404);
    echo 'Not Found';
    exit;
}
$doc = $res->fetch_assoc();
$stmt->close();

// Kebijakan akses pratinjau:
// - Pendidik: hanya dokumen miliknya
// - Verifikator: dokumen menunggu_verifikasi atau diverifikasi
// - Administrator & Root: semua
$role = $_SESSION['user_role'] ?? '';
$uid = (int)($_SESSION['user_id'] ?? 0);
$allowed = false;
if ($role === 'pendidik') {
    // Izinkan pendidik melihat semua dokumen miliknya, termasuk draft/ditolak
    $allowed = ($doc['user_id'] == $uid);
} elseif ($role === 'verifikator') {
    $allowed = in_array($doc['status'], ['menunggu_verifikasi', 'diverifikasi'], true);
} elseif ($role === 'administrator' || $role === 'root' || $role === 'super_administrator') {
    $allowed = true;
}
if (!$allowed) {
    http_response_code(403);
    echo 'Forbidden';
    exit;
}

// Bangun path absolut
$relative = $doc['file_path'];
$absPath = dirname(__DIR__) . '/' . $relative;
if (!is_file($absPath)) {
    http_response_code(404);
    echo 'File Not Found';
    exit;
}

// Validasi MIME: hanya izinkan PDF untuk ditampilkan dalam iframe
$finfo = function_exists('finfo_open') ? finfo_open(FILEINFO_MIME_TYPE) : null;
$mime = $finfo ? finfo_file($finfo, $absPath) : 'application/octet-stream';
if ($finfo) { finfo_close($finfo); }
if ($mime !== 'application/pdf') {
    http_response_code(415);
    echo 'Unsupported Media Type';
    exit;
}

// Set header konten dan kirim file dengan streaming yang lebih aman
// Tutup sesi agar tidak mengunci selama streaming
if (session_status() === PHP_SESSION_ACTIVE) { session_write_close(); }
// Matikan gzip jika aktif untuk menghindari masalah panjang konten
if (function_exists('apache_setenv')) { @apache_setenv('no-gzip', '1'); }
@ini_set('zlib.output_compression', 'Off');
@set_time_limit(0);

header('Content-Type: ' . $mime);
header('Content-Disposition: inline; filename="' . basename($absPath) . '"');
header('X-Content-Type-Options: nosniff');

// Bersihkan buffer output sebelum mengirim file
while (ob_get_level()) { @ob_end_clean(); }

$fp = fopen($absPath, 'rb');
if ($fp) {
    fpassthru($fp);
    fclose($fp);
} else {
    // Fallback jika gagal membuka file
    readfile($absPath);
}
exit;
?>