<?php
require_once '../config/config.php';
require_once '../config/database.php';

// Hanya verifikator, admin, atau root yang boleh mengakses
if (!isLoggedIn() || !(hasRole('verifikator') || hasRole('administrator') || hasRole('root'))) {
    setAlert('Anda tidak memiliki akses ke halaman verifikasi', 'danger');
redirect('/login');
}

// Proses aksi verifikasi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validasi CSRF
    $token = $_POST['csrf_token'] ?? '';
    if (!verify_csrf($token)) {
        setAlert('Sesi tidak valid. Silakan muat ulang halaman dan coba lagi.', 'danger');
        redirect('/pages/verification');
        exit;
    }
    $dokumen_id = isset($_POST['dokumen_id']) ? (int)$_POST['dokumen_id'] : 0;
    $aksi = isset($_POST['aksi']) ? $_POST['aksi'] : '';
    $catatan = isset($_POST['catatan']) ? sanitize($_POST['catatan']) : null;
    if ($dokumen_id > 0 && in_array($aksi, ['setujui','tolak'])) {
        // Ambil info dokumen untuk memindahkan file jika disetujui
        $stmtInfo = $conn->prepare("SELECT file_path, folder_id FROM dokumen WHERE id = ? LIMIT 1");
        $stmtInfo->bind_param("i", $dokumen_id);
        $stmtInfo->execute();
        $resInfo = $stmtInfo->get_result();
        $docInfo = $resInfo && $resInfo->num_rows === 1 ? $resInfo->fetch_assoc() : null;
        $stmtInfo->close();

        // Jika ditolak, ubah status dokumen menjadi 'draft' agar dapat diperbaiki dan diunggah ulang
        $statusBaru = $aksi === 'setujui' ? 'diverifikasi' : 'draft';
        $stmt = $conn->prepare("UPDATE dokumen SET status = ? WHERE id = ?");
        $stmt->bind_param("si", $statusBaru, $dokumen_id);
        if ($stmt->execute()) {
            // Jika disetujui, pindahkan file dari uploads/verifikasi/<folder_id> ke uploads/<folder_id>
            if ($aksi === 'setujui' && $docInfo && !empty($docInfo['file_path'])) {
                $currentRel = $docInfo['file_path'];
                $folderId = (int)$docInfo['folder_id'];
                $baseDir = dirname(__DIR__);
                $srcAbs = $baseDir . '/' . $currentRel;
                $filename = basename($currentRel);
                $destDirAbs = $baseDir . '/uploads/' . $folderId;
                if (!file_exists($destDirAbs)) {
                    @mkdir($destDirAbs, 0755, true);
                }
                $destAbs = $destDirAbs . '/' . $filename;
                // Deteksi apakah file berada di folder verifikasi
                $isInVerifikasi = strpos($currentRel, 'uploads/verifikasi/') === 0;
                if ($isInVerifikasi && file_exists($srcAbs)) {
                    // Jika file tujuan sudah ada, tambahkan suffix numerik agar tidak menimpa
                    $counter = 1;
                    $finalDestAbs = $destAbs;
                    $finalFilename = $filename;
                    while (file_exists($finalDestAbs)) {
                        $pathNoExt = preg_replace('/\.pdf$/i', '', $filename);
                        $finalFilename = $pathNoExt . '_' . $counter . '.pdf';
                        $finalDestAbs = $destDirAbs . '/' . $finalFilename;
                        $counter++;
                    }
                    // Pindahkan file
                    @rename($srcAbs, $finalDestAbs);
                    // Perbarui path relatif di DB
                    $newRel = 'uploads/' . $folderId . '/' . $finalFilename;
                    $stmtUpd = $conn->prepare("UPDATE dokumen SET file_path = ? WHERE id = ?");
                    $stmtUpd->bind_param("si", $newRel, $dokumen_id);
                    $stmtUpd->execute();
                    $stmtUpd->close();
                }
            }
            // Catat verifikasi
            $verifikator_id = (int)$_SESSION['user_id'];
            $stmt2 = $conn->prepare("INSERT INTO verifikasi (dokumen_id, verifikator_id, status, catatan) VALUES (?, ?, ?, ?)");
            $verStatus = $aksi === 'setujui' ? 'disetujui' : 'ditolak';
            $stmt2->bind_param("iiss", $dokumen_id, $verifikator_id, $verStatus, $catatan);
            $stmt2->execute();
            setAlert('Status dokumen diperbarui menjadi ' . $statusBaru, 'success');
            logActivity('Memverifikasi dokumen ID ' . $dokumen_id, 'Aksi: ' . $verStatus);
        } else {
            setAlert('Gagal memperbarui status dokumen: ' . $conn->error, 'danger');
        }
redirect('/pages/verification');
        exit;
    }
}

// Ambil daftar dokumen menunggu verifikasi
$role = $_SESSION['user_role'] ?? '';
$extra = '';
if ($role === 'verifikator') {
    $extra = " AND u.role = 'pendidik'"; // verifikator hanya memverifikasi dokumen pendidik
} elseif ($role === 'administrator') {
    $extra = " AND u.role IN ('pendidik','verifikator')"; // admin memverifikasi pendidik dan verifikator
}
$query = "SELECT d.id, d.judul, d.deskripsi, d.file_path, d.created_at, f.nama_folder, u.nama_lengkap, u.role as uploader_role
          FROM dokumen d
          LEFT JOIN folder f ON d.folder_id = f.id
          LEFT JOIN users u ON d.user_id = u.id
          WHERE d.status = 'menunggu_verifikasi'" . $extra . "
          ORDER BY d.created_at DESC";
$result = $conn->query($query);
$docs = $result && $result instanceof mysqli_result ? $result->fetch_all(MYSQLI_ASSOC) : [];

$pageTitle = 'Verifikasi Dokumen';
include '../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0"><i class="fas fa-clipboard-check"></i> Verifikasi Dokumen</h2>
<a href="<?= BASE_URL ?>/dashboard" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Kembali</a>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Judul</th>
                        <th>Folder</th>
                        <th>Pengunggah</th>
                        <th>Tanggal</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($docs) > 0): ?>
                        <?php $no = 1; foreach ($docs as $d): ?>
                            <tr>
                                <td><?= $no++ ?></td>
                                <td><?= htmlspecialchars($d['judul']) ?></td>
                                <td><?= htmlspecialchars($d['nama_folder'] ?? '-') ?></td>
                                <td><?= htmlspecialchars($d['nama_lengkap'] ?? '-') ?></td>
                                <td><?= date('d/m/Y', strtotime($d['created_at'])) ?></td>
                                <td>
                                    <?php if (!empty($d['file_path'])): ?>
                                        <a href="<?= BASE_URL ?>/pages/preview?id=<?= (int)$d['id'] ?>" class="btn btn-sm btn-info preview-pdf">
                                            <i class="fas fa-eye"></i> Lihat
                                        </a>
                                    <?php endif; ?>
                                    <!-- Tombol membuka modal per baris -->
                                    <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#approveModal-<?= (int)$d['id'] ?>">
                                        <i class="fas fa-check"></i> Setujui
                                    </button>
                                    <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#rejectModal-<?= (int)$d['id'] ?>">
                                        <i class="fas fa-times"></i> Tolak
                                    </button>

                                    <!-- Modal Setujui -->
                                    <div class="modal fade" id="approveModal-<?= (int)$d['id'] ?>" tabindex="-1" aria-labelledby="approveLabel-<?= (int)$d['id'] ?>" aria-hidden="true">
                                      <div class="modal-dialog">
                                        <div class="modal-content">
                                          <div class="modal-header">
                                            <h5 class="modal-title" id="approveLabel-<?= (int)$d['id'] ?>">Konfirmasi Persetujuan</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                          </div>
                                          <div class="modal-body">
                                            Apakah Anda yakin ingin menyetujui dokumen ini?
                                          </div>
                                          <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                            <form method="POST" action="" class="d-inline">
                                                <input type="hidden" name="csrf_token" value="<?= csrf_token() ?>">
                                                <input type="hidden" name="dokumen_id" value="<?= (int)$d['id'] ?>">
                                                <button type="submit" name="aksi" value="setujui" class="btn btn-success">Ya, Setujui</button>
                                            </form>
                                          </div>
                                        </div>
                                      </div>
                                    </div>

                                    <!-- Modal Tolak -->
                                    <div class="modal fade" id="rejectModal-<?= (int)$d['id'] ?>" tabindex="-1" aria-labelledby="rejectLabel-<?= (int)$d['id'] ?>" aria-hidden="true">
                                      <div class="modal-dialog">
                                        <div class="modal-content">
                                          <div class="modal-header">
                                            <h5 class="modal-title" id="rejectLabel-<?= (int)$d['id'] ?>">Alasan Penolakan</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                          </div>
                                          <form method="POST" action="">
                                            <div class="modal-body">
                                                <input type="hidden" name="csrf_token" value="<?= csrf_token() ?>">
                                                <input type="hidden" name="dokumen_id" value="<?= (int)$d['id'] ?>">
                                                <div class="mb-3">
                                                    <label class="form-label">Tuliskan alasan penolakan</label>
                                                    <textarea name="catatan" class="form-control" rows="3" required></textarea>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                <button type="submit" name="aksi" value="tolak" class="btn btn-danger">Tolak Dokumen</button>
                                            </div>
                                          </form>
                                        </div>
                                      </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center">Tidak ada dokumen yang menunggu verifikasi</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>