<?php
require_once '../config/config.php';
require_once '../config/database.php';

// Hanya verifikator, administrator, atau root yang boleh mengakses
if (!isLoggedIn() || !(hasRole('verifikator') || hasRole('administrator') || hasRole('root'))) {
    setAlert('Anda tidak memiliki akses ke halaman verifikasi', 'danger');
    redirect('/login');
    exit;
}

$doc_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($doc_id <= 0) {
    setAlert('Dokumen tidak valid', 'danger');
redirect('/pages/verification');
    exit;
}

// Ambil dokumen menunggu verifikasi
$stmt = $conn->prepare("SELECT d.*, f.nama_folder, u.nama_lengkap, u.role as uploader_role
                        FROM dokumen d
                        LEFT JOIN folder f ON d.folder_id = f.id
                        LEFT JOIN users u ON d.user_id = u.id
                        WHERE d.id = ?");
$stmt->bind_param('i', $doc_id);
$stmt->execute();
$res = $stmt->get_result();
if (!$res || $res->num_rows === 0) {
    setAlert('Dokumen tidak ditemukan', 'danger');
redirect('/pages/verification');
    exit;
}
$doc = $res->fetch_assoc();
$stmt->close();

// Hanya tampilkan aksi jika status menunggu verifikasi dan sesuai kebijakan role
$canAct = $doc['status'] === 'menunggu_verifikasi';
$role = $_SESSION['user_role'] ?? '';
if ($role === 'verifikator' && $doc['uploader_role'] !== 'pendidik') {
    $canAct = false; // verifikator hanya memverifikasi dokumen pendidik
}
if ($role === 'administrator' && !in_array($doc['uploader_role'], ['pendidik','verifikator'])) {
    $canAct = false; // admin memverifikasi pendidik dan verifikator
}

$pageTitle = 'Detail Verifikasi Dokumen';
include '../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2>Detail Verifikasi</h2>
<a href="<?= BASE_URL ?>/pages/verification" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Kembali</a>
</div>

<div class="card">
    <div class="card-body">
        <div class="mb-3">
            <h5 class="mb-1"><?= htmlspecialchars($doc['judul']) ?></h5>
            <div class="text-muted">Folder: <?= htmlspecialchars($doc['nama_folder'] ?? '-') ?> • Pengunggah: <?= htmlspecialchars($doc['nama_lengkap'] ?? '-') ?></div>
        </div>
        <div class="mb-3">
            <p><?= nl2br(htmlspecialchars($doc['deskripsi'] ?? '')) ?></p>
        </div>
        <div class="mb-3">
            <?php if (!empty($doc['file_path'])): ?>
                <?php $absPath = dirname(__DIR__) . '/' . $doc['file_path']; ?>
                <?php if (file_exists($absPath)): ?>
                    <a href="<?= BASE_URL ?>/pages/preview?id=<?= (int)$doc['id'] ?>" class="btn btn-info preview-pdf" target="_blank">
                        <i class="fas fa-eye"></i> Lihat File
                    </a>
                <?php else: ?>
                    <div class="alert alert-warning">File tidak ditemukan di server.</div>
                <?php endif; ?>
            <?php else: ?>
                <div class="alert alert-warning">Tidak ada file terkait.</div>
            <?php endif; ?>
        </div>

        <?php if ($canAct): ?>
            <!-- Tombol membuka modal konfirmasi -->
            <button type="button" class="btn btn-success me-2" data-bs-toggle="modal" data-bs-target="#approveModal">
                <i class="fas fa-check"></i> Setujui
            </button>
            <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#rejectModal">
                <i class="fas fa-times"></i> Tolak
            </button>

            <!-- Modal Setujui -->
            <div class="modal fade" id="approveModal" tabindex="-1" aria-labelledby="approveLabel" aria-hidden="true">
              <div class="modal-dialog">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title" id="approveLabel">Konfirmasi Persetujuan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                    Apakah Anda yakin ingin menyetujui dokumen ini?
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <form method="POST" action="<?= BASE_URL ?>/pages/verification.php" class="d-inline">
                        <input type="hidden" name="csrf_token" value="<?= csrf_token() ?>">
                        <input type="hidden" name="dokumen_id" value="<?= (int)$doc_id ?>">
                        <button type="submit" name="aksi" value="setujui" class="btn btn-success">Ya, Setujui</button>
                    </form>
                  </div>
                </div>
              </div>
            </div>

            <!-- Modal Tolak -->
            <div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectLabel" aria-hidden="true">
              <div class="modal-dialog">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title" id="rejectLabel">Alasan Penolakan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <form method="POST" action="<?= BASE_URL ?>/pages/verification.php">
                    <div class="modal-body">
                        <input type="hidden" name="csrf_token" value="<?= csrf_token() ?>">
                        <input type="hidden" name="dokumen_id" value="<?= (int)$doc_id ?>">
                        <div class="mb-3">
                            <label class="form-label">Tuliskan alasan penolakan</label>
                            <textarea name="catatan" class="form-control" rows="3" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" name="aksi" value="tolak" class="btn btn-danger">Tolak Dokumen</button>
                    </div>
                  </form>
                </div>
              </div>
            </div>
        <?php else: ?>
            <div class="alert alert-info">Dokumen ini tidak tersedia untuk tindakan verifikasi oleh peran Anda.</div>
        <?php endif; ?>
    </div>
    <div class="card-footer">
        <small class="text-muted">Status saat ini: <?= ucfirst(str_replace('_',' ', $doc['status'])) ?></small>
    </div>
</div>

<?php include '../includes/footer.php'; ?>