<?php
require_once '../config/config.php';
require_once '../config/database.php';

// Hanya akses jika ada sesi pending OTP
if (!isset($_SESSION['pending_otp_user_id'])) {
    setAlert('Sesi verifikasi OTP tidak ditemukan. Silakan login kembali.', 'warning');
    redirect('/login');
}

$userId = (int)$_SESSION['pending_otp_user_id'];
$username = $_SESSION['pending_otp_username'] ?? '';
$error = '';
$info = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = $_POST['csrf_token'] ?? '';
    if (!verify_csrf($token)) {
        $error = 'Sesi tidak valid. Silakan muat ulang halaman.';
    } else {
        if (isset($_POST['action']) && $_POST['action'] === 'verify') {
            $code = trim($_POST['otp_code'] ?? '');
            if ($code === '') {
                $error = 'Kode OTP harus diisi.';
            } elseif (!preg_match('/^\d{6}$/', $code)) {
                $error = 'Kode OTP harus berupa 6 digit angka.';
            } else {
                if (verifyOtpCode($userId, $code)) {
                    // Ambil data user untuk set sesi penuh
                    $stmt = $conn->prepare("SELECT id, username, nama_lengkap, email, role FROM users WHERE id = ?");
                    $stmt->bind_param('i', $userId);
                    $stmt->execute();
                    $res = $stmt->get_result();
                    $user = $res->fetch_assoc();
                    $stmt->close();
                    if ($user) {
                        $_SESSION['user_id'] = $user['id'];
                        $_SESSION['user_username'] = $user['username'];
                        $_SESSION['user_name'] = $user['nama_lengkap'];
                        $_SESSION['user_email'] = $user['email'];
                        $_SESSION['user_role'] = $user['role'];
                        // Set token sesi tunggal (single device)
                        setUserSessionToken((int)$user['id']);
                        session_regenerate_id(true);
                        // Update last_login
                        $ustmt = $conn->prepare("UPDATE users SET last_login = CURRENT_TIMESTAMP WHERE id = ?");
                        $ustmt->bind_param('i', $user['id']);
                        $ustmt->execute();
                        $ustmt->close();
                        // Log aktivitas
                        $ip = $_SERVER['REMOTE_ADDR'] ?? '';
                        $lstmt = $conn->prepare("INSERT INTO log_aktivitas (user_id, aktivitas, ip_address) VALUES (?, 'Verifikasi OTP Berhasil', ?)");
                        $lstmt->bind_param('is', $user['id'], $ip);
                        $lstmt->execute();
                        $lstmt->close();
                        // Bersihkan sesi pending
                        unset($_SESSION['pending_otp_user_id'], $_SESSION['pending_otp_username'], $_SESSION['otp_last_code']);
                        // Redirect
                        redirect('/dashboard');
                    } else {
                        $error = 'User tidak ditemukan.';
                    }
                } else {
                    $error = 'Kode OTP salah atau kedaluwarsa.';
                }
            }
        } elseif (isset($_POST['action']) && $_POST['action'] === 'resend') {
            if (canResendOtp($userId)) {
                // Ambil email user
                $stmt = $conn->prepare("SELECT email FROM users WHERE id = ?");
                $stmt->bind_param('i', $userId);
                $stmt->execute();
                $res = $stmt->get_result();
                $urow = $res->fetch_assoc();
                $stmt->close();
                $email = $urow['email'] ?? '';
                $code = createOtpForUser($userId); // akan mengembalikan kode yang sama jika masih berlaku (<10 menit)
                sendOtpEmail($email, $code);
                markOtpSent($userId);
                $info = 'Kode OTP telah dikirim ulang ke email.';
            } else {
                $error = 'Terlalu sering mengirim OTP. Coba lagi nanti.';
            }
        }
    }
}

// Header minimal
$pageTitle = 'Verifikasi OTP';
include '../includes/header.php';
?>
<div class="row justify-content-center">
  <div class="col-md-6 col-lg-5">
    <div class="card mt-4">
      <div class="card-body">
        <h5 class="card-title mb-3"><i class="fas fa-shield-alt"></i> Verifikasi OTP</h5>
        <p class="text-muted">Masukkan kode OTP yang telah dikirim ke email akun <strong><?= htmlspecialchars($username) ?></strong>. Kode berlaku maksimal <?= OTP_TTL_MINUTES ?> menit.</p>
        <?php if (!empty($error)): ?>
          <div class="alert alert-danger"><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8') ?></div>
        <?php endif; ?>
        <?php if (!empty($info)): ?>
          <div class="alert alert-info"><?= htmlspecialchars($info, ENT_QUOTES, 'UTF-8') ?></div>
        <?php endif; ?>
        <?php if (defined('OTP_DEBUG_DISPLAY') && OTP_DEBUG_DISPLAY && !empty($_SESSION['otp_last_code'])): ?>
          <div class="alert alert-warning"><i class="fas fa-bug"></i> Mode uji lokal: Kode OTP adalah <strong><?= htmlspecialchars($_SESSION['otp_last_code']) ?></strong></div>
        <?php endif; ?>
        <form method="post" action="">
          <input type="hidden" name="csrf_token" value="<?= csrf_token() ?>">
          <div class="mb-3">
            <label for="otp_code" class="form-label">Kode OTP</label>
            <div class="input-group">
              <span class="input-group-text"><i class="fas fa-key"></i></span>
              <input type="text" class="form-control" id="otp_code" name="otp_code" placeholder="Masukkan 6 digit kode" required>
            </div>
          </div>
          <div class="d-flex gap-2">
            <button type="submit" name="action" value="verify" class="btn btn-primary"><i class="fas fa-check"></i> Verifikasi</button>
            <button type="submit" name="action" value="resend" class="btn btn-outline-secondary" formnovalidate><i class="fas fa-redo"></i> Kirim Ulang</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<?php include '../includes/footer.php'; ?>